/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.exprcomp;

import filenet.vw.base.exprcomp.IDistributions;
import java.util.Random;

public class Distributions
implements IDistributions {
    private static IDistributions s_this = new Distributions(1014);
    private static final double MIN_E_EXP = Math.log(Double.MIN_VALUE);
    private static final double MAX_E_EXP = Math.log(Double.MAX_VALUE);
    private Random m_random;

    private Distributions(int nSeed) {
        this.m_random = new Random(nSeed);
    }

    public static IDistributions getInstance() {
        return s_this;
    }

    public int bernoulli(double probability) {
        if (probability <= 0.0 || probability >= 1.0) {
            throw new IllegalArgumentException("binomial: probability must be between 0 and 1");
        }
        double U = this.random();
        return U <= probability ? 1 : 0;
    }

    public double beta(double shape1, double shape2, double lbound, double ubound) {
        double Y2;
        double Y1;
        if (shape1 <= 0.0) {
            throw new IllegalArgumentException("beta: shape1 must be greater than zero");
        }
        if (shape2 <= 0.0) {
            throw new IllegalArgumentException("beta: shape2 must be greater than zero");
        }
        if (ubound <= lbound) {
            throw new IllegalArgumentException("beta: upper bound must be greater than lower bound");
        }
        while ((Y1 = this.gamma(shape1, 1.0)) + (Y2 = this.gamma(shape2, 1.0)) == 0.0) {
        }
        double X = Y1 / (Y1 + Y2);
        return lbound + (ubound - lbound) * X;
    }

    public int binomial(int trials, double probability) {
        if (trials < 1) {
            throw new IllegalArgumentException("binomial: trials must be greater than zero");
        }
        if (probability <= 0.0 || probability >= 1.0) {
            throw new IllegalArgumentException("binomial: probability must be between 0 and 1");
        }
        int Y = 0;
        for (int i = 0; i < trials; ++i) {
            Y += this.bernoulli(probability);
        }
        return Y;
    }

    public double exponential(double mean) {
        if (mean <= 0.0) {
            throw new IllegalArgumentException("exponential: mean must be zero or greater");
        }
        double U = this.randomNon0();
        return -mean * Math.log(U);
    }

    public double gamma(double shape, double scale) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("gamma: shape must be greater than zero");
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException("gamma: scale must be greater than zero");
        }
        if (shape < 1.0) {
            double Y;
            double U2;
            double U1;
            double P;
            double b = (Math.E + shape) / Math.E;
            do {
                U1 = this.randomNon0();
                U2 = this.randomNon0();
            } while (!((P = b * U1) > 1.0 ? U2 <= Math.pow(Y = -Math.log((b - P) / shape), shape - 1.0) : U2 <= Math.pow(Math.E, -(Y = Math.pow(P, 1.0 / shape)))));
            return scale * Y;
        }
        if (shape > 1.0) {
            double Y;
            double Z;
            double W;
            double a = 1.0 / Math.sqrt(2.0 * shape - 1.0);
            double b = shape - Math.log(4.0);
            double q = shape + 1.0 / a;
            double theta = 4.5;
            double d = 1.0 + Math.log(theta);
            do {
                double U1 = this.randomNon01();
                double U2 = this.randomNon0();
                double V = a * Math.log(U1 / (1.0 - U1));
                W = b + q * V - (Y = shape * Math.pow(Math.E, V));
                if (!(W + d - theta * (Z = U1 * U1 * U2) >= 0.0)) continue;
                return scale * Y;
            } while (!(W >= Math.log(Z)));
            return scale * Y;
        }
        return this.exponential(scale);
    }

    public int geometric(double probability) {
        if (probability <= 0.0 || probability >= 1.0) {
            throw new IllegalArgumentException("geometric: probability must be between 0 and 1");
        }
        double U = this.randomNon0();
        return (int)Math.floor(Math.log(U) / Math.log(1.0 - probability));
    }

    public double lognormal(double mean, double variance) {
        double Y;
        if (variance <= 0.0) {
            throw new IllegalArgumentException("normal: variance must be greater than zero");
        }
        while ((Y = this.normal(mean, variance)) < MIN_E_EXP || Y > MAX_E_EXP) {
        }
        return Math.exp(Y);
    }

    public double normal(double mean, double variance) {
        double V2;
        double V1;
        double W;
        if (variance <= 0.0) {
            throw new IllegalArgumentException("normal: variance must be greater than zero");
        }
        while ((W = (V1 = 2.0 * this.random() - 1.0) * V1 + (V2 = 2.0 * this.random() - 1.0) * V2) > 1.0 || W == 0.0) {
        }
        double Y = Math.sqrt(-2.0 * Math.log(W) / W);
        return mean + variance * V1 * Y;
    }

    public int poisson(double mean) {
        if (mean <= 0.0 || mean > MAX_E_EXP) {
            throw new IllegalArgumentException("poisson: mean must be between zero and log(Double.MAX_VALUE)");
        }
        double a = Math.exp(-mean);
        double b = 1.0;
        int i = 0;
        while (!((b *= this.random()) < a)) {
            ++i;
        }
        return i;
    }

    public double uniform(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("uniform: max must be grater than min");
        }
        double U = this.random();
        return min + U * (max - min);
    }

    public double weibull(double shape, double scale) {
        if (shape <= 0.0) {
            throw new IllegalArgumentException("weibull: shape must be greater than zero");
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException("weibull: scale must be greater than zero");
        }
        double U = this.randomNon0();
        return scale * Math.pow(-Math.log(U), 1.0 / shape);
    }

    public void setSeed(long nSeed) {
        this.m_random.setSeed(nSeed);
    }

    public double random() {
        return this.m_random.nextDouble();
    }

    private double randomNon0() {
        double x;
        while ((x = this.random()) == 0.0) {
        }
        return x;
    }

    private double randomNon01() {
        double x;
        while ((x = this.random()) == 0.0 || x == 1.0) {
        }
        return x;
    }
}

